@extends('layouts.admin')

@section('title', 'Add Manual Payment Gateway')

@section('content')
<div class="container-fluid px-4">
    <div class="d-flex justify-content-between align-items-center mt-4 mb-4">
        <h1 class="h3 fw-bold text-primary">
            <i class="fas fa-plus-circle me-2"></i> Add Manual Payment Gateway
        </h1>
        <a href="{{ route('admin.payment.gateways') }}" class="btn btn-outline-primary btn-sm shadow-sm">
            <i class="fas fa-arrow-left"></i> Back to Settings
        </a>
    </div>

    <!-- Manual Payment Gateway Form -->
    <div class="card shadow-lg border-0 mb-5">
        <div class="card-header bg-gradient-primary text-white d-flex align-items-center">
            <h4 class="mb-0"><i class="fas fa-tools me-2"></i> Add Manual Payment Gateway</h4>
        </div>
        <div class="card-body p-4">
            <form action="{{ route('admin.payment-gateways.storeManual') }}" method="POST" class="gateway-form bg-white p-5 rounded shadow-sm border border-light">
                @csrf

                <!-- Gateway Name -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Gateway Name (e.g., Bitcoin, Litecoin)</label>
                    <input type="text" name="gateway_name" class="form-control form-control-lg" placeholder="Enter Gateway Name" required>
                </div>

                <!-- Status Switch -->
                <div class="form-check form-switch mb-4">
                    <input type="checkbox" class="form-check-input" name="is_active" id="activeToggle">
                    <label class="form-check-label" for="activeToggle">Enable Gateway</label>
                </div>

                <!-- Manual Payment Type -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Payment Type (e.g., BTC, LTC)</label>
                    <input type="text" name="manual_payment_type" class="form-control form-control-lg" placeholder="e.g., Bitcoin, Litecoin" required>
                </div>

                <!-- Manual Payment Details (Address/ID) -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Payment Details (Wallet Address/Payment ID)</label>
                    <input type="text" name="manual_payment_details" class="form-control form-control-lg" placeholder="e.g., Wallet Address, Payment ID" required>
                </div>

                <!-- Currency -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Currency</label>
                    <select name="currency" class="form-select form-select-lg" required>
                        <option value="usd">USD ($)</option>
                        <option value="eur">EUR (€)</option>
                        <option value="gbp">GBP (£)</option>
                        <option value="btc">BTC (₿)</option>
                        <option value="ltc">LTC (Ł)</option>
                    </select>
                </div>

                <!-- Minimum Transaction Amount -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Min Transaction Amount</label>
                    <div class="input-group">
                        <span class="input-group-text"><i class="fas fa-dollar-sign"></i></span>
                        <input type="number" name="min_transaction_amount" class="form-control form-control-lg" placeholder="Minimum Transaction Amount" min="1" required>
                    </div>
                </div>

                <!-- Description (Optional) -->
                <div class="mb-4">
                    <label class="form-label fw-semibold">Description (Optional)</label>
                    <textarea name="description" class="form-control form-control-lg" rows="4" placeholder="Provide any additional details or description for this payment gateway"></textarea>
                </div>

                <!-- Submit Button -->
                <div class="text-end">
                    <button type="submit" class="btn btn-gradient-primary btn-lg shadow">
                        <i class="fas fa-save"></i> Add Manual Gateway
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    // Confirm submission for better user experience
    document.querySelector('.gateway-form').addEventListener('submit', function(event) {
        if (!confirm('Are you sure you want to add this payment gateway?')) {
            event.preventDefault();
        }
    });
</script>
@endsection
