@extends('layouts.admin')

@section('title', 'Create User')

@section('content')
<div class="container-fluid px-4">
    <div class="row mb-4">
        <div class="col-12">
            <h2 class="mt-4 text-center text-primary fw-bold border-bottom pb-3">
                <i class="fas fa-user-plus me-2"></i> Create New User
            </h2>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-5 rounded-4">
        <div class="card-header bg-gradient-primary text-white rounded-top">
            <strong><i class="fas fa-user-cog me-2"></i> User Details</strong>
        </div>
        <div class="card-body bg-light p-4">
            <form action="{{ route('admin.user.store') }}" method="POST" class="needs-validation" novalidate>
                @csrf

                <div class="row g-3">
                    <div class="col-md-6">
                        <label for="name" class="form-label fw-bold">Name <span class="text-danger">*</span></label>
                        <input type="text" name="name" id="name" class="form-control shadow-sm rounded-pill" required>
                        <div class="invalid-feedback">
                            Please provide a name.
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="email" class="form-label fw-bold">Email Address <span class="text-danger">*</span></label>
                        <input type="email" name="email" id="email" class="form-control shadow-sm rounded-pill" required>
                        <div class="invalid-feedback">
                            Please provide a valid email address.
                        </div>
                    </div>
                </div>

                <div class="row g-3 mt-3">
                    <div class="col-md-6">
                        <label for="password" class="form-label fw-bold">Password <span class="text-danger">*</span></label>
                        <input type="password" name="password" id="password" class="form-control shadow-sm rounded-pill" required>
                        <div class="invalid-feedback">
                            Please provide a password.
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="password_confirmation" class="form-label fw-bold">Confirm Password <span class="text-danger">*</span></label>
                        <input type="password" name="password_confirmation" id="password_confirmation" class="form-control shadow-sm rounded-pill" required>
                        <div class="invalid-feedback">
                            Please confirm the password.
                        </div>
                    </div>
                </div>

                <div class="row g-3 mt-3">
                    <div class="col-md-6">
                        <label for="is_active" class="form-label fw-bold">User Status <span class="text-danger">*</span></label>
                        <select name="is_active" id="is_active" class="form-select shadow-sm rounded-pill" required>
                            <option value="1">Active</option>
                            <option value="0">Inactive</option>
                        </select>
                        <div class="invalid-feedback">
                            Please select the user status.
                        </div>
                    </div>

                    <div class="col-md-6 d-flex align-items-center">
                        <div class="form-check">
                            <input type="checkbox" class="form-check-input shadow-sm" id="is_ib" name="is_ib">
                            <label class="form-check-label fw-bold ms-2" for="is_ib">Is IB (Introducing Broker)</label>
                        </div>
                    </div>
                </div>

                <div class="d-flex justify-content-between mt-4">
                    <button type="submit" class="btn btn-success shadow-sm rounded-pill"><i class="fas fa-save me-2"></i> Save User</button>
                    <a href="{{ route('admin.users') }}" class="btn btn-secondary shadow-sm rounded-pill"><i class="fas fa-arrow-left me-2"></i> Cancel</a>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection