<?php

namespace App\Providers;

use Illuminate\Foundation\Support\Providers\AuthServiceProvider as ServiceProvider;
use Illuminate\Support\Facades\Gate;

class AuthServiceProvider extends ServiceProvider
{
    /**
     * The model to policy mappings for the application.
     *
     * @var array<class-string, class-string>
     */
    protected $policies = [
        // Map models to policies here, e.g.,
        // 'App\Models\ModelName' => 'App\Policies\ModelNamePolicy',
    ];

    /**
     * Register any authentication/authorization services.
     */
    public function boot(): void
    {
        $this->registerPolicies();

        // Define Gates for Role-Based Access Control
        Gate::define('manage-users', function ($user) {
            return $user->hasRole('admin');
        });

        Gate::define('view-reports', function ($user) {
            return $user->hasRole('admin') || $user->hasRole('IB');
        });

        Gate::define('manage-transactions', function ($user) {
            return $user->hasRole('admin');
        });

        Gate::define('access-trading-tools', function ($user) {
            return $user->hasAnyRole(['admin', 'user', 'IB']);
        });

        Gate::define('manage-settings', function ($user) {
            return $user->hasRole('admin');
        });

        Gate::define('assign-roles', function ($user) {
            return $user->hasRole('admin');
        });

        Gate::define('view-dashboard', function ($user) {
            return $user->hasRole('admin');
        });

        Gate::define('view-user-dashboard', function ($user) {
            return $user->hasRole('user');
        });

        // Allow both admin and user roles to transfer funds
        Gate::define('transfer-funds', function ($user) {
            return $user->hasAnyRole(['admin', 'user']);
        });

        Gate::define('view-trades', function ($user) {
            return $user->hasAnyRole(['admin', 'user']); // Allow 'admin' and 'user' roles to view trades
        });

        Gate::define('manage-trades', function ($user) {
            return $user->hasRole('admin'); // Only admins can manage trades
        });

        // Define Gate for admin activity logs
        Gate::define('view-admin-activity-logs', function ($user) {
            return $user->hasRole('admin');
        });

        // Define Gate for user activity logs
        Gate::define('view-user-activity-logs', function ($user) {
            return $user->hasRole('user');
        });

        Gate::define('view-ib-dashboard', function ($user) {
            return $user->hasRole('user'); // Ensure this user is a regular user
        });
    }
}
