<?php

namespace App\Http\Controllers;

use App\Models\Referral;
use App\Models\CommissionWithdrawal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\IBRelationship;
use App\Models\IBHierarchy;
use App\Models\User;

class UserIBReportController extends Controller
{
    public function index()
    {
        $user = Auth::user();
        $referrals = Referral::where('referrer_id', $user->id)->with('referredUser')->paginate(10);
        $withdrawals = CommissionWithdrawal::where('user_id', $user->id)->paginate(10);
        $totalEarnings = Referral::where('referrer_id', $user->id)->sum('earnings');

        return view('user.ib-reports.index', compact('referrals', 'withdrawals', 'totalEarnings'));
    }

    public function requestWithdrawal(Request $request)
    {
        $request->validate([
            'amount' => 'required|numeric|min:1',
        ]);

        $user = Auth::user();
        CommissionWithdrawal::create([
            'user_id' => $user->id,
            'amount' => $request->amount,
            'status' => 'pending',
        ]);

        return redirect()->route('user.ib-reports')->with('success', 'Withdrawal request submitted.');
    }
}
