<?php

namespace App\Http\Controllers;

use App\MT5\Services\MT5Service;
use Illuminate\Http\Request;

class MT5Controller extends Controller
{
    protected $mt5Service;

    public function __construct()
    {
        $this->mt5Service = new MT5Service();
    }

    public function createAccount(Request $request)
    {
        $data = $request->validate([
            'name' => 'required|string',
            'group' => 'required|string',
            'leverage' => 'required|integer',
            'password' => 'required|string',
            'investor_password' => 'required|string',
        ]);

        $response = $this->mt5Service->createAccount($data);
        $this->mt5Service->disconnect();

        return response()->json($response);
    }

    public function getTrades($login)
    {
        $response = $this->mt5Service->getTrades($login);
        $this->mt5Service->disconnect();

        return response()->json($response);
    }

    public function transferFunds(Request $request)
    {
        $data = $request->validate([
            'login' => 'required|string',
            'amount' => 'required|numeric',
            'type' => 'required|in:deposit,withdraw',
        ]);

        $response = $this->mt5Service->transferFunds($data);
        $this->mt5Service->disconnect();

        return response()->json($response);
    }
}
