<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\KycDocument;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class KycController extends Controller
{
    /**
     * Display the KYC form or the KYC status for the user.
     *
     * @return \Illuminate\View\View
     */
    public function showKycForm()
    {
        $kyc = KycDocument::where('user_id', Auth::id())->latest()->first();
        return view('user.kyc', compact('kyc'));
    }

    /**
     * Handle the submission of KYC documents by the user.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function submitKyc(Request $request)
    {
        $request->validate([
            'passport' => 'nullable|file|mimes:jpeg,png,pdf|max:2048',
            'driver_license' => 'nullable|file|mimes:jpeg,png,pdf|max:2048',
            'nid' => 'nullable|file|mimes:jpeg,png,pdf|max:2048',
            'other_documents' => 'nullable|file|mimes:jpeg,png,pdf|max:2048',
        ]);

        $kycData = [
            'user_id' => Auth::id(),
            'status' => 'pending',
        ];

        foreach (['passport', 'driver_license', 'nid', 'other_documents'] as $field) {
            if ($request->hasFile($field)) {
                // Remove old file if it exists
                $existingKyc = KycDocument::where('user_id', Auth::id())->first();
                if ($existingKyc && $existingKyc->$field) {
                    Storage::disk('public')->delete($existingKyc->$field);
                }

                // Store the new file
                $kycData[$field] = $request->file($field)->store('kyc', 'public');
            }
        }

        // Update or create the KYC document
        KycDocument::updateOrCreate(['user_id' => Auth::id()], $kycData);

        return redirect()->route('user.kyc')->with('success', 'KYC documents submitted successfully!');
    }
}
