<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\IBCommissionLevel;

class IBCommissionLevelController extends Controller
{
    /**
     * Display a listing of the commission levels.
     */
    public function index()
    {
        $commissionLevels = IBCommissionLevel::all();
        return view('admin.ib-commission-levels.index', compact('commissionLevels'));
    }

    /**
     * Show the form for creating a new commission level.
     */
    public function create()
    {
        return view('admin.ib-commission-levels.create');
    }

    /**
     * Store a newly created commission level in the database.
     */
    public function store(Request $request)
    {
        $request->validate([
            'level' => 'required|integer|unique:ib_commission_levels,level',
            'commission_percentage' => 'required|numeric|min:0|max:100',
        ]);

        IBCommissionLevel::create($request->all());

        return redirect()->route('admin.ib-commission-levels.index')->with('success', 'Commission level created successfully.');
    }

    /**
     * Show the form for editing the specified commission level.
     */
    public function edit($id)
    {
        $commissionLevel = IBCommissionLevel::findOrFail($id);
        return view('admin.ib-commission-levels.edit', compact('commissionLevel'));
    }

    /**
     * Update the specified commission level in the database.
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'level' => 'required|integer|unique:ib_commission_levels,level,' . $id,
            'commission_percentage' => 'required|numeric|min:0|max:100',
        ]);

        $commissionLevel = IBCommissionLevel::findOrFail($id);
        $commissionLevel->update($request->all());

        return redirect()->route('admin.ib-commission-levels.index')->with('success', 'Commission level updated successfully.');
    }

    /**
     * Remove the specified commission level from the database.
     */
    public function destroy($id)
    {
        $commissionLevel = IBCommissionLevel::findOrFail($id);
        $commissionLevel->delete();

        return redirect()->route('admin.ib-commission-levels.index')->with('success', 'Commission level deleted successfully.');
    }
}
